//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL GetHeaderOnly(char *FileName)
{
    HSTMT fstmt;

    if(OpenDB(MasterDriver, MasterServer, MasterUID, MasterPWS, MasterDatabase) == FALSE)
    {
        ErrorMessage(MainDialog_hWnd, "Failed to connect to local master database");
        return FALSE;
    }

    char StatementText[1024];
    int Result = 0;

    sprintf(StatementText, "RESTORE HEADERONLY FROM DISK = '%s'", FileName);
    Result = DBexecute(StatementText, &fstmt);

    SQLINTEGER dataID;

    Result = SQLFetch(fstmt);
    if(Result != SQL_SUCCESS && Result != SQL_SUCCESS_WITH_INFO)
    {
        ErrorMessage(MainDialog_hWnd, "Failed to retreive backup information from the file you selected.");
        return FALSE;
    }
    Result = SQLGetData(fstmt, 8, SQL_C_CHAR, UserName, 100, &dataID);
    Result = SQLGetData(fstmt, 9, SQL_C_CHAR, ServerName, 100, &dataID);
    Result = SQLGetData(fstmt, 10, SQL_C_CHAR, DatabaseName, 100, &dataID);
    Result = SQLGetData(fstmt, 11, SQL_C_CHAR, DatabaseVersion, 100, &dataID);
    Result = SQLGetData(fstmt, 12, SQL_C_CHAR, DatabaseCreationDate, 100, &dataID);
    Result = SQLGetData(fstmt, 13, SQL_C_CHAR, BackupSize, 100, &dataID);
    Result = SQLGetData(fstmt, 18, SQL_C_CHAR, BackupStartDate, 100, &dataID);
    Result = SQLGetData(fstmt, 19, SQL_C_CHAR, BackupEndDate, 100, &dataID);
    Result = SQLGetData(fstmt, 24, SQL_C_CHAR, CompatibilityLevel, 100, &dataID);
    Result = SQLGetData(fstmt, 29, SQL_C_CHAR, MachineName, 100, &dataID);
    Result = SQLGetData(fstmt, 31, SQL_C_CHAR, BindingID, 100, &dataID);
    Result = SQLGetData(fstmt, 32, SQL_C_CHAR, RecoveryForkID, 100, &dataID);
    Result = SQLGetData(fstmt, 33, SQL_C_CHAR, Collation, 100, &dataID);

    DBclose();

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL GetFileListOnly(char *FileName)
{
    HSTMT fstmt;

    if(OpenDB(MasterDriver, MasterServer, MasterUID, MasterPWS, MasterDatabase) == FALSE)
    {
        ErrorMessage(MainDialog_hWnd, "Failed to connect to local master database");
        return FALSE;
    }

    char StatementText[1024];
    int Result = 0;

    sprintf(StatementText, "RESTORE FILELISTONLY FROM DISK = '%s'", FileName);
    Result = DBexecute(StatementText, &fstmt);

    SQLINTEGER dataID;

    Result = SQLFetch(fstmt);
    if(Result != SQL_SUCCESS && Result != SQL_SUCCESS_WITH_INFO)
    {
        ErrorMessage(MainDialog_hWnd, "Failed to retreive backup information from the file you selected.");
        return FALSE;
    }
    Result = SQLGetData(fstmt, 1, SQL_C_CHAR, LogicalName1, 100, &dataID);
    Result = SQLGetData(fstmt, 2, SQL_C_CHAR, PhysicalName1, 100, &dataID);
    Result = SQLGetData(fstmt, 3, SQL_C_CHAR, Type1, 100, &dataID);
    Result = SQLGetData(fstmt, 4, SQL_C_CHAR, FileGroupName1, 100, &dataID);
    Result = SQLGetData(fstmt, 5, SQL_C_CHAR, Size1, 100, &dataID);
    Result = SQLGetData(fstmt, 6, SQL_C_CHAR, MaxSize1, 100, &dataID);

    Result = SQLFetch(fstmt);
    if(Result != SQL_SUCCESS && Result != SQL_SUCCESS_WITH_INFO)
    {
        ErrorMessage(MainDialog_hWnd, "Failed to retreive backup information from the file you selected.");
        return FALSE;
    }
    Result = SQLGetData(fstmt, 1, SQL_C_CHAR, LogicalName2, 100, &dataID);
    Result = SQLGetData(fstmt, 2, SQL_C_CHAR, PhysicalName2, 100, &dataID);
    Result = SQLGetData(fstmt, 3, SQL_C_CHAR, Type2, 100, &dataID);
    Result = SQLGetData(fstmt, 4, SQL_C_CHAR, FileGroupName2, 100, &dataID);
    Result = SQLGetData(fstmt, 5, SQL_C_CHAR, Size2, 100, &dataID);
    Result = SQLGetData(fstmt, 6, SQL_C_CHAR, MaxSize2, 100, &dataID);

    DBclose();

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

